unit OrderServices;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Diagnostics, System.Web,
  System.Web.Services,
  Borland.Eco.ObjectRepresentation, 
  Borland.Eco.Handles;

type
  TWebService1 = class(System.Web.Services.WebService)
  {$REGION 'Designer Managed Code'}
  strict private
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: IContainer;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: Borland.Eco.Handles.EcoSpace;
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;    
  strict protected
    procedure Dispose(disposing: boolean); override;
  {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObject;
  {$ENDREGION}
  public
    constructor Create;
    // Sample Web Service Method
    [WebMethod]
    function HelloWorld: string;
    [WebMethod]
    function OrderCount: integer;
    [WebMethod]
    procedure NewOrder(Name: String);
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider, CoreClassesUnit;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebService1.InitializeComponent;
begin    
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  //
  // rhRoot
  //
  Self.rhRoot.EcoSpace := nil;
  Self.rhRoot.StaticValueTypeName := '';
  Self.rhRoot.Variables := nil;
end;
{$ENDREGION}

constructor TWebService1.Create;
begin
  inherited;
  //
  // Required for Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

{$REGION 'Utility Methods'}
procedure TWebService1.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TWebService1.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TWebService1.ObjectForId(Id: string): IObject;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

procedure TWebService1.Dispose(disposing: boolean);
begin
  if disposing and (components <> nil) then
    components.Dispose;
  inherited Dispose(disposing);
end;

function TWebService1.get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fecoSpace := TEcoSpaceProvider.GetSessionFreeEcoSpace;
		rhRoot.EcoSpace := fEcoSpace;
		// Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TWebService1.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or it's contents here.
	// Otherwise it is not safe to return it to a pool

  TEcoSpaceProvider.ReturnSessionFreeEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

// Sample Web Service Methods
// The following method is provided to allow for testing a new web service.
function TWebService1.HelloWorld: string;
begin
  Result := 'Hello World';
end;

// This is a minimal web method reading data,
function TWebService1.OrderCount: integer;
var
  OclService: IOclService;
  ResultElement: IElement;
begin
  EcoSpace.Active := true;
  OclService := EcoSpace.GetEcoService(typeof(IOclService)) as IOclService;
  ResultElement := OclService.EvaluateAndSubscribe(nil, 'Order.allInstances->size', nil, nil);
  Result := Integer(ResultElement.AsObject);
  DoneWithEcoSpace;
end;

// This is a minimal web method modifying data
procedure TWebService1.NewOrder(Name: String);
var
  anOrder: Order;
begin
  EcoSpace.Active := true;
  anOrder := Order.Create(EcoSpace);
  anOrder.Customer := Name;
  UpdateDatabase;
  DoneWithEcoSpace;
end;

end.

